/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.ParameterContainer;
import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.dataconnect.SearchResultContainer;
import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.Responder;
import com.belenus.interpartsserver3.Server;
import com.belenus.util.StringUtil;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class SearchResponder
extends Responder {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$SearchResponder == null ? (class$com$belenus$interpartsserver3$SearchResponder = SearchResponder.class$("com.belenus.interpartsserver3.SearchResponder")) : class$com$belenus$interpartsserver3$SearchResponder));
    protected static final String RESULT_ID_PREFACE = "searchresponder.result.";
    protected InterpartsServer m_interpartsServer;
    protected DatabaseManager m_databaseManager;
    protected PrintWriter m_printWriter;
    protected Properties m_queryTemplates;
    protected Properties m_toPathQueryTemplates;
    protected Properties m_actualPathQueryTemplates;
    protected Properties m_tabledefs;
    protected Properties m_tabledefQueries;
    protected String m_defaultToPathQueryTemplate;
    protected String m_defaultActualPathQueryTemplate;
    protected boolean m_searchMultilinePathes;
    protected int m_searchEntriesPerPage;
    protected boolean m_searchRecursiveTree;
    protected boolean m_searchReverseTree;
    protected int m_searchEntriesMax;
    protected boolean m_searchCount;
    protected SearchResultContainer m_searchResultContainer;
    protected int m_queryIndex;
    protected int m_resultIndex;
    protected int m_toPathIndex;
    protected int m_pageIndex;
    protected String m_resultId;
    protected String m_queryParameter;
    protected Locale m_locale;
    protected Locale m_guiLocale;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$SearchResponder;

    public SearchResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Server server) {
        super(httpServletRequest, httpServletResponse, server);
        this.m_interpartsServer = (InterpartsServer)this.m_server;
        this.m_databaseManager = this.m_interpartsServer.getDatabaseManager();
        this.m_queryTemplates = this.m_interpartsServer.m_searchQueries;
        this.m_toPathQueryTemplates = this.m_interpartsServer.m_searchToPathQueries;
        this.m_actualPathQueryTemplates = this.m_interpartsServer.m_searchActualPathQueries;
        this.m_tabledefs = this.m_interpartsServer.m_searchTabledefs;
        this.m_tabledefQueries = this.m_interpartsServer.m_tabledefQueries;
        this.m_defaultToPathQueryTemplate = this.m_interpartsServer.m_searchDefaultToPathQuery;
        this.m_defaultActualPathQueryTemplate = this.m_interpartsServer.m_searchDefaultActualPathQuery;
        this.m_searchEntriesPerPage = this.m_interpartsServer.m_searchEntriesPerPage;
        this.m_searchRecursiveTree = this.m_interpartsServer.m_searchRecursiveTree;
        this.m_searchReverseTree = this.m_interpartsServer.m_searchReverseTree;
        this.m_searchEntriesMax = this.m_interpartsServer.m_searchEntriesMax;
        this.m_searchMultilinePathes = this.m_interpartsServer.m_searchMultilinePathes;
        this.m_searchCount = this.m_interpartsServer.m_searchCount;
        this.m_locale = this.m_interpartsServer.m_serverDispatcher.getDataLocale(httpServletRequest);
        this.m_guiLocale = this.m_interpartsServer.m_serverDispatcher.getGuiLocale(httpServletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void respond() throws Exception {
        block8: {
            this.m_databaseManager.startTransaction();
            this.m_queryParameter = this.m_httpServletRequest.getParameter("query");
            this.m_resultId = this.m_httpServletRequest.getParameter("resultid");
            this.prepareOutput();
            this.showPage();
            this.finishOutput();
            Object var3_1 = null;
            try {
                this.m_databaseManager.finishTransaction();
            }
            catch (Exception exc2) {
                logger.error((Object)exc2, (Throwable)exc2);
            }
            break block8;
            {
                catch (Exception exc) {
                    logger.error((Object)exc, (Throwable)exc);
                    Object var3_2 = null;
                    try {
                        this.m_databaseManager.finishTransaction();
                    }
                    catch (Exception exc2) {
                        logger.error((Object)exc2, (Throwable)exc2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.m_databaseManager.finishTransaction();
                }
                catch (Exception exc2) {
                    logger.error((Object)exc2, (Throwable)exc2);
                }
                throw throwable;
            }
        }
    }

    protected void prepareOutput() throws UnsupportedEncodingException {
        this.m_httpServletResponse.setContentType("text/html");
        this.m_printWriter = new PrintWriter(this.startOutputStream(true, true));
    }

    protected void finishOutput() {
        this.m_printWriter.close();
    }

    protected boolean getSearchResultContainer() {
        String restart = this.m_httpServletRequest.getParameter("restart");
        HttpSession httpSession = this.m_httpServletRequest.getSession();
        this.m_searchResultContainer = (SearchResultContainer)httpSession.getAttribute(RESULT_ID_PREFACE + this.m_resultId);
        if ("true".equals(restart) && this.m_searchResultContainer != null) {
            logger.debug((Object)("Removing result " + this.m_resultId));
            httpSession.removeAttribute(RESULT_ID_PREFACE + this.m_resultId);
            this.m_searchResultContainer.destroy();
            this.m_searchResultContainer = null;
            if (this.m_queryParameter == null) {
                return false;
            }
        }
        if (this.m_searchResultContainer == null) {
            int searchEntriesMax = this.m_searchEntriesMax;
            try {
                searchEntriesMax = Integer.parseInt(this.m_httpServletRequest.getParameter("searchmax"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_searchResultContainer = this.constructSearchResultContainer(searchEntriesMax);
            httpSession.setAttribute(RESULT_ID_PREFACE + this.m_resultId, (Object)this.m_searchResultContainer);
        } else {
            ParameterContainer parameterContainer = new ParameterContainer(this.m_httpServletRequest, this.m_configurator);
            this.m_searchResultContainer.setParameterContainer(parameterContainer);
        }
        return true;
    }

    protected void setSearchResultContainerOffset() {
        int offset;
        this.m_queryIndex = this.getInteger(this.m_httpServletRequest.getParameter("queryindex"), 0);
        this.m_resultIndex = this.getInteger(this.m_httpServletRequest.getParameter("resultindex"), 0);
        this.m_toPathIndex = this.getInteger(this.m_httpServletRequest.getParameter("topathindex"), 0);
        this.m_pageIndex = this.getInteger(this.m_httpServletRequest.getParameter("pageindex"), 1);
        this.m_searchResultContainer.set(this.m_queryIndex, this.m_resultIndex, this.m_toPathIndex);
        this.m_searchResultContainer.currentResultWithOverflow();
        for (offset = this.getInteger(this.m_httpServletRequest.getParameter("offset"), 0); offset < 0; ++offset) {
            this.m_searchResultContainer.previousToPathWithOverflow();
        }
        while (offset > 0) {
            --offset;
            this.m_searchResultContainer.nextToPathWithOverflow();
        }
        this.m_queryIndex = this.m_searchResultContainer.currentQueryIndex();
        this.m_resultIndex = this.m_searchResultContainer.currentResultIndex();
        this.m_toPathIndex = this.m_searchResultContainer.currentToPathIndex();
    }

    protected void initializeSearchResultContainer() {
        boolean isValidSearchResultContainer = this.getSearchResultContainer();
        if (isValidSearchResultContainer) {
            this.setSearchResultContainerOffset();
        }
    }

    private SearchResultContainer constructSearchResultContainer(int searchEntriesMax) {
        String[] queries = StringUtil.split(this.m_queryParameter, ",");
        String[] queryTemplates = new String[queries.length];
        String[] toPathQueryTemplates = new String[queries.length];
        String[] actualPathQueryTemplates = new String[queries.length];
        String[] tabledefQueryTemplates = new String[queries.length];
        for (int queriesIndex = 0; queriesIndex < queries.length; ++queriesIndex) {
            queryTemplates[queriesIndex] = (String)this.m_queryTemplates.get(queries[queriesIndex].trim());
            String toPathQueryTemplate = (String)this.m_toPathQueryTemplates.get(queries[queriesIndex].trim());
            toPathQueryTemplates[queriesIndex] = toPathQueryTemplate != null ? toPathQueryTemplate : this.m_defaultToPathQueryTemplate;
            String actualPathQueryTemplate = (String)this.m_actualPathQueryTemplates.get(queries[queriesIndex].trim());
            actualPathQueryTemplates[queriesIndex] = actualPathQueryTemplate != null ? actualPathQueryTemplate : this.m_defaultActualPathQueryTemplate;
            String tabledefName = (String)this.m_tabledefs.get(queries[queriesIndex].trim());
            if (tabledefName != null) {
                String tabledefQuery;
                tabledefQueryTemplates[queriesIndex] = tabledefQuery = (String)this.m_tabledefQueries.get(tabledefName);
            }
            actualPathQueryTemplates[queriesIndex] = actualPathQueryTemplate != null ? actualPathQueryTemplate : this.m_defaultActualPathQueryTemplate;
        }
        ParameterContainer parameterContainer = new ParameterContainer(this.m_httpServletRequest, this.m_configurator);
        return new SearchResultContainer(this.m_databaseManager, parameterContainer, queries, queryTemplates, toPathQueryTemplates, actualPathQueryTemplates, tabledefQueryTemplates, this.m_searchRecursiveTree, this.m_searchReverseTree, searchEntriesMax, this.m_searchCount);
    }

    private int getInteger(String input, int defaultInteger) {
        if (input != null) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultInteger;
    }

    protected abstract void showPage();

    protected String buildTreePath(Row toPathRow) {
        String id_object;
        String id_parent;
        StringBuffer treeToPathStringBuffer = new StringBuffer();
        RowContainer actualPathRowContainer = toPathRow.getContainingRowContainer();
        actualPathRowContainer.resetPosition();
        if (actualPathRowContainer.isEmpty()) {
            return "";
        }
        HashSet<String> usedIds = new HashSet<String>();
        while (actualPathRowContainer.hasNext()) {
            Row actualPathRow = actualPathRowContainer.nextRow();
            id_parent = actualPathRow.getString("id_parent");
            treeToPathStringBuffer.append("/").append(id_parent);
            usedIds.add(id_parent);
        }
        String id_device = toPathRow.getString("id_device");
        if (!"".equals(id_device) && !usedIds.contains(id_device)) {
            treeToPathStringBuffer.append("/").append(id_device);
        }
        if (!"".equals(id_parent = toPathRow.getString("id_parent")) && !usedIds.contains(id_parent)) {
            treeToPathStringBuffer.append("/").append(id_parent);
        }
        if (!"".equals(id_object = toPathRow.getString("id_object")) && !usedIds.contains(id_object)) {
            treeToPathStringBuffer.append("/").append(id_object);
        }
        return treeToPathStringBuffer.toString();
    }

    protected void buildHeaderDefinition(StringBuffer result, RowContainer rowContainer, String meaning, RowContainer tabledefRowContainer) {
        String[] fieldNames = rowContainer.getFieldNamesByMeaning(meaning);
        block0: for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.length; ++fieldNamesIndex) {
            String fieldName = fieldNames[fieldNamesIndex];
            tabledefRowContainer.resetPosition();
            while (tabledefRowContainer.hasNext()) {
                Row tabledefRow = tabledefRowContainer.nextRow();
                String tabledefFieldName = meaning + "_" + tabledefRow.getString("att_id");
                if (fieldName.equals(tabledefFieldName)) {
                    String headerName = tabledefRow.getString("header_name", this.m_guiLocale, true);
                    this.addToList(result, headerName);
                    continue block0;
                }
                if (tabledefRowContainer.hasNext()) continue;
                this.addToListWithNull(result, null);
                continue block0;
            }
        }
    }

    protected abstract void addToList(StringBuffer var1, String var2);

    protected abstract void addToListWithNull(StringBuffer var1, String var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

